import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';
import 'package:get/get.dart';
import 'package:play_lab/core/utils/styles.dart';
import 'package:play_lab/view/components/custom_loader/custom_loader.dart';
import '../../../core/utils/dimensions.dart';

import '../../../core/utils/my_color.dart';

class RoundedButton extends StatelessWidget {
  final String text;
  final VoidCallback press;
  final Color color, textColor;
  final double width;
  final double hPadding;
  final double vPadding;
  final double vRadius;
  final bool isLoading;
  const RoundedButton({
    super.key,
    this.width = 1,
    required this.text,
    required this.press,
    this.color = MyColor.primaryColor,
    this.textColor = Colors.white,
    this.hPadding = 24,
    this.vPadding = 18,
    this.vRadius = Dimensions.extraRadius,
    this.isLoading = false,
  });

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SizedBox(
      width: size.width * width,
      child: ElevatedButton(
        onPressed: isLoading ? () {} : press,
        style: ElevatedButton.styleFrom(
          backgroundColor: color,
          padding: EdgeInsets.symmetric(horizontal: hPadding, vertical: vPadding),
          textStyle: TextStyle(color: textColor, fontSize: 14, fontWeight: FontWeight.w500),
          shadowColor: color.withValues(alpha: 0.5),
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(vRadius),
          ),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            if (isLoading) ...[
              SizedBox(height: 22, child: SpinKitCircle(color: textColor, size: 20))
            ] else ...[
              Text(text.tr, style: mulishSemiBold.copyWith(color: textColor, fontSize: 18)),
            ],
          ],
        ),
      ),
    );
  }
}
